/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.computer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.report.urgentpath.AuthorizationWaiting;
import cz.insophy.inplan.report.urgentpath.CapacityWaiting;
import cz.insophy.inplan.report.urgentpath.MaterialWaiting;
import cz.insophy.inplan.report.urgentpath.ReleaseDateWaiting;
import cz.insophy.inplan.report.urgentpath.ToolWaiting;
import cz.insophy.inplan.report.urgentpath.UrgentPathAnalyzer;
import cz.insophy.inplan.report.urgentpath.UrgentPathInfo;
import cz.insophy.inplan.report.urgentpath.UrgentPathInfoBuilder;
import cz.insophy.inplan.report.urgentpath.Waiting;
import cz.insophy.inplan.report.urgentpath.WaitingVisitor;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.superplan.Superplan;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayIndexComputer {
    private static final Logger log = LoggerFactory.getLogger(DelayIndexComputer.class);
    @VisibleForTesting
    static final long SMALL_WAITING_THRESHOLD = 60000L;
    private final Map<String, DelayIndex> capabilityIndexes = Maps.newHashMap();
    private final Map<String, DelayIndex> materialIndexes = Maps.newHashMap();
    private final Map<String, DelayIndex> toolIndexes = Maps.newHashMap();

    public DelayIndexComputer(Superplan superplan) {
        this.evaluateResources(superplan);
    }

    private void evaluateResources(Superplan superplan) {
        UrgentPathAnalyzer upa = new UrgentPathAnalyzer(superplan);
        UrgentPathInfoBuilder builder = UrgentPathInfo.builder(superplan);
        DelayIndexUpdater delayIndexUpdater = new DelayIndexUpdater();
        for (CustomerRequest cr : superplan.getCustomerRequests()) {
            UrgentPathInfo urgentPathInfo = builder.build(upa.computeUrgentPath(cr), cr);
            if (!urgentPathInfo.isCrDelayed()) continue;
            long crDelay = urgentPathInfo.getCrDelay();
            double factor = 1.0 / (double)Math.max(crDelay * (long)cr.getPriority(), 1L);
            delayIndexUpdater.setCrDelay(crDelay);
            delayIndexUpdater.setFactor(factor);
            urgentPathInfo.accept(delayIndexUpdater);
        }
        double max = DelayIndexComputer.maxIndex(this.toolIndexes, this.capabilityIndexes, this.materialIndexes);
        this.normalizeIndexes(this.toolIndexes, max);
        this.normalizeIndexes(this.capabilityIndexes, max);
        this.normalizeIndexes(this.materialIndexes, max);
    }

    @SafeVarargs
    private static double maxIndex(Map<String, DelayIndex> ... idxMaps) {
        double max = 0.0;
        for (Map<String, DelayIndex> indexes : idxMaps) {
            for (DelayIndex delayIndex : indexes.values()) {
                if (!(max < delayIndex.getIndex())) continue;
                max = delayIndex.getIndex();
            }
        }
        return max;
    }

    private void normalizeIndexes(Map<String, DelayIndex> delayIndexes, double max) {
        for (DelayIndex idx : delayIndexes.values()) {
            idx.setIndex(idx.getIndex() / max);
        }
    }

    public Map<String, DelayIndex> getToolIndexes() {
        return Collections.unmodifiableMap(this.toolIndexes);
    }

    public Map<String, DelayIndex> getCapabilityIndexes() {
        return Collections.unmodifiableMap(this.capabilityIndexes);
    }

    public Map<String, DelayIndex> getMaterialIndexes() {
        return Collections.unmodifiableMap(this.materialIndexes);
    }

    public double getDelayIndex(@Nonnull Material material) {
        DelayIndex res = material.isConsumed() ? this.materialIndexes.get(material.getName()) : this.toolIndexes.get(material.getName());
        return res != null ? res.getIndex() : 0.0;
    }

    public double getDelayIndex(@Nonnull String capability) {
        Preconditions.checkNotNull(capability);
        DelayIndex delayIndex = this.capabilityIndexes.get(capability);
        return delayIndex != null ? delayIndex.getIndex() : 0.0;
    }

    @Nullable
    public String getMostDelayingCapability() {
        return this.getMostDelayingResource(this.capabilityIndexes);
    }

    @Nullable
    public String getMostDelayingMaterial() {
        return this.getMostDelayingResource(this.materialIndexes);
    }

    @Nullable
    public String getMostDelayingTool() {
        return this.getMostDelayingResource(this.toolIndexes);
    }

    @Nullable
    private String getMostDelayingResource(Map<String, DelayIndex> indexMap) {
        double max = 0.0;
        String maxRes = null;
        for (Map.Entry<String, DelayIndex> entry : indexMap.entrySet()) {
            DelayIndex idx = entry.getValue();
            if (!(max < idx.getIndex())) continue;
            max = idx.getIndex();
            maxRes = entry.getKey();
        }
        return maxRes;
    }

    private class DelayIndexUpdater
    implements WaitingVisitor {
        private long crDelay;
        private double factor;

        private DelayIndexUpdater() {
        }

        public void setCrDelay(long crDelay) {
            this.crDelay = crDelay;
        }

        public void setFactor(double factor) {
            this.factor = factor;
        }

        private void updateIndex(@Nonnull String id, @Nonnull Map<String, DelayIndex> indexMap, @Nonnull Waiting waiting) {
            if (waiting.getLength() <= 60000L) {
                return;
            }
            DelayIndex idx = indexMap.get(id);
            if (idx == null) {
                idx = new DelayIndex();
                indexMap.put(id, idx);
            }
            idx.addIndex((double)Math.min(waiting.getLength(), this.crDelay) * this.factor);
        }

        @Override
        public void visit(CapacityWaiting waiting) {
            this.updateIndex(waiting.getCapability(), DelayIndexComputer.this.capabilityIndexes, waiting);
        }

        @Override
        public void visit(AuthorizationWaiting waiting) {
            String constraint = waiting.getConstraint();
            if (constraint != null) {
                this.updateIndex(constraint, DelayIndexComputer.this.capabilityIndexes, waiting);
            } else {
                StringBuilder sb = new StringBuilder();
                if (waiting.getGor() != null) {
                    sb.append(waiting.getGor().getId());
                    if (waiting.getGar() != null) {
                        sb.append(':');
                        sb.append(waiting.getGar().getAction());
                    }
                } else {
                    sb.append("unknown");
                }
                log.debug("Cannot find authorization waiting constraint id for waiting on {}.", (Object)sb.toString());
            }
        }

        @Override
        public void visit(ToolWaiting waiting) {
            for (Material mat : waiting.getMaterials()) {
                this.updateIndex(mat.getName(), DelayIndexComputer.this.toolIndexes, waiting);
            }
        }

        @Override
        public void visit(MaterialWaiting waiting) {
            for (Material mat : waiting.getMaterials()) {
                this.updateIndex(mat.getName(), DelayIndexComputer.this.materialIndexes, waiting);
            }
        }

        @Override
        public void visit(ReleaseDateWaiting waiting) {
        }
    }

    public static class DelayIndex {
        private double index;

        public double getIndex() {
            return this.index;
        }

        private void addIndex(double val) {
            this.index += val;
        }

        private void setIndex(double index) {
            this.index = index;
        }
    }
}

